// crc.c


unsigned int crc;

#include "spi.h"



// CRC adapted from http://www.fearme.com/misc/alg/node191.html
//  see also http://www.lammertbies.nl/comm/info/crc-calculation.html

unsigned short crc_16_table[16] = {
	0x0000, 0xCC01, 0xD801, 0x1400, 0xF001, 0x3C00, 0x2800, 0xE401,
	0xA001, 0x6C00, 0x7800, 0xB401, 0x5000, 0x9C01, 0x8801, 0x4400
};




inline void crc_calc(unsigned char c)
{
	unsigned int r;

	/* compute checksum of lower four bits of *p */
	r = crc_16_table[crc & 0xF];
	crc = (crc >> 4) & 0x0FFF;
	crc = crc ^ r ^ crc_16_table[c & 0xF];

	/* now compute checksum of upper four bits of *p */
	r = crc_16_table[crc & 0xF];
	crc = (crc >> 4) & 0x0FFF;
	crc = crc ^ r ^ crc_16_table[(c >> 4) & 0xF];
}

void crc_init()
// set crc to zero before starting new calculation
{
	crc = 0;
}

unsigned short crc_calc_buffer(unsigned char *dat, unsigned int len)
// calculate checksum over (len) bytes starting at (dat)
// returns current crc value at end
{
	unsigned int i;
	for(i=0; i<len; ++i)
		crc_calc(*dat++);
	return crc;
}
/*
unsigned short crc_calc_spiflash(unsigned long start, unsigned long len)
// calculate crc-16 checksum of spi flash
{
	unsigned long a, l;
	unsigned int s;
	crc = 0;
	a = start;
	l = 0;
	for(;;) {
		spibuff[1] = 3;		// read data bytes
		spibuff[2] = (a >> 16) & 0xff;
		spibuff[3] = (a >> 8) & 0xff;
		spibuff[4] = a & 0xff;
		spi_transfer_block(&spi_flash, 260);
		for(s=0; s<256; ++s) {
			crc_calc(*(spibuff+4+s));
			++l;
			if(l >= len)
				return crc;
		}
		a += 256;
	}

	return crc;
}

unsigned short crc_calc_progflash(unsigned long start, unsigned long len)
// calculate crc-16 checksum of program flash 
//  start is address in words (as used by ReadLatch) and len
//  is length in long words (really 24-bit words)
{
	start &= 0xfffffe;		// 24-bit address; make sure LSB is 0

	crc = 0;
	unsigned long l, a;
	a = start;
	for(l = 0; l < len; ++l)	{
		uReg32 inst;
		inst.Val32 = ReadLatch((UWord16)((a & 0xff0000) >> 16), (UWord16)(a & 0xfffe));
		// inst.Val[0,1,2] contain instruction; inst.Val[3] is unused, but assume it is
		//  zero and use it to calc chksum (it will be stored as 0 in the SPI flash - 
		//  it's zero in the Microchip HEX file)
		short i;
		for(i=0; i<3; ++i) {
			crc_calc(inst.Val[i]);
		}
		crc_calc(0xff);		// high-order byte isn't used (instructions are 24 bits),
							// but this byte is stored in the SPI flash as a 0xff
		a += 2;
	}
	return crc;
}

*/
